<?php

namespace Lunar\Admin\Support\Synthesizers;

use Lunar\FieldTypes\ListField;

class ListSynth extends AbstractFieldSynth
{
    public static $key = 'lunar_list_field';

    protected static $targetClass = ListField::class;

    public function dehydrate($target)
    {
        return parent::dehydrate($target); // TODO: Change the autogenerated stub
    }

    public function get(&$target, $key)
    {
        return (array) $target->getValue();
    }

    public function set(&$target, $key, $value)
    {
        $fieldValue = (array) $target->getValue();
        $fieldValue[$key] = $value;
        $target->setValue($fieldValue);
    }

    public function unset(&$target, $index)
    {
        $fieldValue = (array) $target->getValue();
        unset($fieldValue[$index]);

        $target->setValue($fieldValue);
    }
}
